<?php

namespace App\Actions;

use App\Enums\ChatStatus;
use App\Models\Chat;
use App\Models\User;
use Illuminate\Support\Facades\DB;

final class CreateChatAction
{
    public function handle(User $user, string $roomName): Chat
    {
        return DB::transaction(function () use ($user, $roomName): Chat {
            $chat = $user->chats()->firstOrNew(
                [
                    'livekit_room_name' => $roomName,
                ],
            );

            if (!$chat->exists) {
                $chat->status = ChatStatus::NEW;
                $chat->save();
            }


            return $chat;
        });
    }
}
