<?php

namespace App\Actions;

use App\Models\Admin;
use App\Models\Chat;
use App\Models\ChatRate;
use App\Models\User;
use Illuminate\Support\Facades\DB;

final readonly class CreateChatRateAction
{
    public function handle(
        array  $data,
    ): ChatRate
    {

            DB::BeginTransaction();
            $chat = Chat::query()->findOrFail(
                id: $data['chat_id'],
            );
            if (!$chat) {
                throw new \Exception('Chat not found');
            }
            $data['ratefromable_id'] = auth()->user()->id;
            $data['ratefromable_type'] = auth()->user()::class;

            if($data['ratetoable_type'] == 'user')
                $data['ratetoable_type'] = User::class;
            else
                $data['ratetoable_type'] = Admin::class;


            $rate = $chat->rates()->create(
                attributes: [
                    'ratefromable_id' => $data['ratefromable_id'],
                    'ratefromable_type' => $data['ratefromable_type'],
                    'ratetoable_id' => $data['ratetoable_id'],
                    'ratetoable_type' => $data['ratetoable_type'],
                    'chat_id' => $data['chat_id'],
                    'rate' => $data['rate'],
                    'comment' => $data['comment'] ?? null,
                ]
            );
            DB::commit();
            return $rate;
    }
}
