<?php

namespace App\Actions;

use App\Enums\MessageType;
use App\Models\Chat;
use App\Models\Message;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\DB;

final readonly class CreateMessageAction
{
    public function handle(
        Chat   $chat,
        array  $data,
        ?array $attachments = null,
    ): Message
    {
        return DB::transaction(function () use ($chat, $data, $attachments): Message {
            $messageType = MessageType::TEXT;

            $message = $chat->messages()->create(
                attributes: [
                    'type' => $messageType,
                ] + $data,
            );

            if ($attachments) {
                /** @var UploadedFile $attachment */
                foreach ($attachments as $attachment) {
                    $message->addMedia($attachment)
                        ->toMediaCollection('attachments');
                }
            }

            $message->load('media', 'replyTo', 'replyTo.sender');

            return $message;
        });
    }
}
