<?php

namespace App\Actions;

use App\Enums\SupportCallStatus;
use App\Exceptions\LiveKitException;
use App\Models\SupportCall;
use App\Models\User;
use App\Services\LiveKitService;
use Illuminate\Support\Str;
use Random\RandomException;

final readonly class CreateSupportCallAction
{
    public function __construct(private LiveKitService $service)
    { }

    /**
     * @throws RandomException
     * @throws LiveKitException
     */
    public function handle(array $attributes, User $user): SupportCall
    {
        $type = $attributes['type'];

        $call = SupportCall::query()
            ->where('user_id', $user->id)
            ->where('type', $type)
            ->whereIn('status', [SupportCallStatus::PENDING, SupportCallStatus::IN_PROGRESS])
            ->latest()
            ->first();

        if (!$call) {
            $call = SupportCall::create([
                'user_id' => $user->id,
                'type' => $type,
                'status' => SupportCallStatus::PENDING,
                'room_name' => Str::random(random_int(30, 50)),
                'started_at' => now(),
                'chat_id' => $attributes['chat_id'],
            ]);
        }

        $room = $this->service->createRoom($call->room_name);

        if (empty($room['success'])) {
            throw new LiveKitException('LiveKit service error: ' . ($room['error'] ?? 'Unknown error'));
        }

        return $call;
    }
}
