<?php

namespace App\Actions;

use App\DataObjects\LiveKitData;
use App\Exceptions\LiveKitException;
use App\Models\Admin;
use App\Models\SupportCall;
use App\Models\User;
use App\Services\LiveKitService;

final readonly class GenerateLiveKitTokenAction
{
    public function __construct(
        private LiveKitService $service,
    )
    {
    }

    /**
     * @throws LiveKitException
     */
    public function handle(SupportCall $call, User|Admin $user): LiveKitData
    {
        $token = $this->service->generateAccessToken($call->room_name, $user->name);

        if (!$token['success']) {
            throw new LiveKitException('LiveKit service error: ' . $token['error']);
        }

        return new LiveKitData(
            token: $token['token'],
            roomName: $call->room_name,
            sessionId: isset($room) ? $room['room']->getSid() : null,
            roomCreatedAt: isset($room) ? $room['room']->getCreationTime() : null,
        );
    }
}
