<?php

namespace App\Actions;

use App\Events\MessageUpdatedEvent;
use App\Models\Message;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\DB;

final readonly class UpdateMessageAction
{
    public function handle(
        Message $message,
        array   $data,
        ?array  $attachments = null,
    ): Message
    {
        return DB::transaction(function () use ($message, $data, $attachments): Message {
            $message->update(
                attributes: $data,
            );

            $message->deleteMedia('attachments');

            if ($attachments) {
                /** @var UploadedFile $attachment */
                foreach ($attachments as $attachment) {
                    $message->addMedia($attachment)
                        ->withCustomProperties(['file_type' => $attachment->getClientMimeType()])
                        ->toMediaCollection('attachments');
                }
            }

            MessageUpdatedEvent::dispatch($message);

            return $message;
        });
    }
}
