<?php

namespace App\Console\Commands;

use App\Models\Branch;
use App\Models\Chat;
use Illuminate\Console\Command;

class CreateBranchGroupChats extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:create-branch-group-chats';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create group chats for all branches that don\'t have them';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('Creating branch group chats...');

        $branches = Branch::whereDoesntHave('groupChat')->get();

        if ($branches->isEmpty()) {
            $this->info('All branches already have group chats.');

            return;
        }

        $created = 0;

        foreach ($branches as $branch) {
            Chat::create([
                'livekit_room_name' => "branch_group_chat_{$branch->id}",
                'status' => 'active',
                'type' => 'group',
                'branch_id' => $branch->id,
                'user_id' => null,
                'admin_id' => null,
            ]);

            $created++;
            $this->info("Created group chat for branch: {$branch->name}");
        }

        $this->info("Successfully created {$created} branch group chats.");
    }
}
