<?php

namespace App\Events;

use App\Models\Chat;
use App\Models\SupportCall;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class NewSupportCallEvent implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public function __construct(
        private readonly SupportCall $call,
    )
    {
    }

    public function broadcastOn(): array
    {
        return [
            new PrivateChannel('Support.Chat.' . $this->call->chat_id),
            new PrivateChannel('Support.Chats'),
        ];
    }

    public function broadcastAs(): string
    {
        return 'NewSupportCall';
    }

    public function broadcastWith(): array
    {
        return [
            'id' => $this->call->id,
            'status' => $this->call->status,
            'type' => $this->call->type,
            'room_name' => $this->call->room_name,
            'started_at' => $this->call->started_at,
            'answered_at' => $this->call->answered_at,
            'ended_at' => $this->call->ended_at,
            'chat_id' => $this->call->chat_id,
            'user' => [
                'id' => $this->call->user->id,
                'name' => $this->call->user->name,
                'photo_url' => $this->call->user->photo_url,
            ],
        ];
    }
}
