<?php

namespace App\Events;

use App\Models\SupportCall;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class UpdateSupportCallEvent implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public function __construct(
        private readonly SupportCall $call,
    )
    {
    }

    public function broadcastOn(): array
    {
        return [
            new PrivateChannel('Support.Chat.' . $this->call->chat_id),
            new PrivateChannel('Support.Chats'),
        ];
    }

    public function broadcastAs(): string
    {
        return 'UpdateSupportCall';
    }

    public function broadcastWith(): array
    {
        return [
            'id' => $this->call->id,
            'status' => $this->call->status,
        ];
    }
}
