<?php

namespace App\Http\Controllers\API\V1\Auth;

use App\Contracts\FetchAuthenticatedUserContract;
use App\Services\LiveKitService;
use Exception;
use Illuminate\Http\JsonResponse;

final readonly class TokenController
{
    public function __construct(
        private FetchAuthenticatedUserContract $user,
        private LiveKitService         $service
    )
    {
        $this->service->setIdentity(
            identity: $this->user->handle()->name,
        );
    }

    /**
     * @throws Exception
     */
    public function __invoke()
    {
        return new JsonResponse(
            data: [
                'token' => $this->service->generateToken(
                    isCreator: true,
                ),
            ],
        );
    }
}
