<?php

namespace App\Http\Controllers\API\V1\Calls;

use App\Enums\SupportCallStatus;
use App\Events\UpdateSupportCallEvent;
use App\Models\SupportCall;

final class DestroyController
{
    public function __invoke(SupportCall $call)
    {
        abort_unless($call->user_id === auth()->id(), 403);

        $call->update([
            'status' => SupportCallStatus::ENDED,
            'ended_at' => now(),
        ]);

        event(new UpdateSupportCallEvent($call));

        return response(status: 200)->json();
    }
}
