<?php

namespace App\Http\Controllers\API\V1\Calls\Join;

use App\Actions\GenerateLiveKitTokenAction;
use App\Enums\SupportCallStatus;
use App\Exceptions\LiveKitException;
use App\Http\Controllers\Controller;
use App\Http\Resources\SupportCallResource;
use App\Models\SupportCall;
use Illuminate\Http\Request;

class StoreController extends Controller
{
    /**
     * @throws LiveKitException
     */
    public function __invoke(
        Request                    $request,
        SupportCall                $call,
        GenerateLiveKitTokenAction $tokenAction,
    )
    {
        abort_unless($request->user()->id == $call->user_id, 403);

        $data = $tokenAction->handle($call, $request->user());

        $call->update([
            'status' => SupportCallStatus::IN_PROGRESS,
        ]);

        return (new SupportCallResource($call))->additional([
            'token' => $data->token,
        ]);
    }
}
