<?php

namespace App\Http\Controllers\API\V1\Calls;

use App\Actions\CreateSupportCallAction;
use App\Actions\GenerateLiveKitTokenAction;
use App\Events\NewSupportCallEvent;
use App\Exceptions\LiveKitException;
use App\Http\Requests\CreateSupportCallRequest;
use App\Http\Resources\SupportCallResource;
use App\Jobs\MarkCallAsMissedJob;
use Random\RandomException;

final class StoreController
{
    /**
     * @throws LiveKitException
     * @throws RandomException
     */
    public function __invoke(
        CreateSupportCallRequest   $request,
        CreateSupportCallAction    $action,
        GenerateLiveKitTokenAction $tokenAction,
    )
    {
        $call = $action->handle($request->validated(), $request->user());
        $data = $tokenAction->handle($call, $request->user());

        event(new NewSupportCallEvent($call));

        MarkCallAsMissedJob::dispatch($call)->delay(now()->addMinutes(5));

        return (new SupportCallResource($call))->additional([
            'token' => $data->token,
        ]);
    }
}
