<?php

namespace App\Http\Controllers\API\V1\ChatRates;

use App\Actions\CreateChatRateAction;
use App\Http\Requests\StoreChatRateRequest;
use App\Http\Resources\ChatRateResource;
use App\Models\Chat;
use App\Models\User;

final readonly class StoreController
{
    public function __invoke(
        CreateChatRateAction $action,
        StoreChatRateRequest $request,
    )
    {
        $ChatRate = $action->handle($request->validated());

        return new ChatRateResource(
            resource: $ChatRate,
        );
    }
}
