<?php

namespace App\Http\Controllers\API\V1\Chats;

use App\Contracts\FetchChatsByUserContract;
use App\Http\Resources\ChatResource;

final readonly class IndexController
{
    public function __construct(
        private FetchChatsByUserContract             $query,
        private readonly FetchMessagesByChatContract $messagsQuery,
    )
    {
    }

    public function __invoke()
    {
        $pinnedMessages = $this->query->handle(
            user: auth()->user(),
            filter: ['is_pinned' => true]
        )->latest();

        return ChatResource::collection(
            resource: $this->query->handle(
                user: auth()->user(),
            )->latest()->jsonPaginate()
        );
    }
}
