<?php

namespace App\Http\Controllers\API\V1\Chats;

use App\Contracts\FetchMessagesByChatContract;
use App\Http\Resources\MessageResource;
use App\Models\Chat;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;

final readonly class ShowController
{
    use AuthorizesRequests;

    public function __construct(
        private FetchMessagesByChatContract $query,
    ) {}

    public function __invoke(
        Chat $chat,
    ) {
        abort_unless($chat->user_id == auth()->id(), 403);

        $pinnedMessages = $this->query->handle(
            chat: $chat,
            filters: ['is_pinned' => true]
        )->latest()->get(['id', 'sender_id', 'sender_type', 'chat_id', 'text', 'reply_to_id']);

        return MessageResource::collection(
            resource: $this->query->handle(
                chat: $chat,
            )->latest()->jsonPaginate()
        )->additional([
            'pinned_messages' => $pinnedMessages,
        ]);
    }
}
