<?php

namespace App\Http\Controllers\API\V1\Chats;

use App\Actions\CreateChatAction;
use App\Http\Resources\ChatResource;
use App\Models\User;
use App\Services\LiveKitService;

final readonly class StoreController
{
    public function __invoke(
        CreateChatAction $action,
    )
    {
        /** @var User $user */
        $user = auth()->user();

        $roomName = "support_chat_{$user->id}";

        $chat = $action->handle($user, $roomName);

//        $this->service->setIdentity(
//            identity: $user->name
//        )->createRoom(
//            roomName: $chat->livekit_room_name,
//        );

        return new ChatResource(
            resource: $chat,
        );
    }
}
