<?php

namespace App\Http\Controllers\API\V1\Messages;

use App\Contracts\FetchMessagesByChatContract;
use App\Http\Controllers\Controller;
use App\Http\Resources\MessageResource;
use Illuminate\Contracts\Support\Responsable;

class IndexController extends Controller
{
    public function __construct(
        private readonly FetchMessagesByChatContract $query,
    )
    { }

    public function __invoke(): Responsable
    {
        return MessageResource::collection(
            resource: $this->query->handle(
                user: auth()->user(),
            )->latest()->jsonPaginate()
        );
    }
}
