<?php

namespace App\Http\Controllers\API\V1\Messages;

use App\Actions\CreateMessageAction;
use App\Enums\MessageType;
use App\Events\NewChatMessage;
use App\Http\Controllers\Controller;
use App\Http\Requests\StoreMessageRequest;
use App\Models\Chat;
use App\Models\User;

class StoreController extends Controller
{
    public function __invoke(
        StoreMessageRequest $request,
        CreateMessageAction $action,
    )
    {
        /** @var User $user */
        $user = auth()->user();

        $chat = Chat::query()->findOrFail(
            id: $request->integer('chat_id'),
        );

        $message = $action->handle(
            chat: $chat,
            data: [
                'type' => $request->enum('type', MessageType::class),
                'text' => $request->string('text')->toString(),
                'chat_id' => $request->integer('chat_id'),
                'reply_to_id' => $request->integer('reply_to_id') ?: null,
                'sender_id' => $user->id,
                'sender_type' => $user::class,
            ],
            attachments: $request->files?->get("attachments"),
        );

        if ($request->has('tmp_front_id')) {
            $message->tmp_front_id = $request->string('tmp_front_id')->toString();
        }

        event(new NewChatMessage($chat, $message));

        return response()->json(
            data: [
                'message' => $message,
            ],
            status: 201,
        );
    }
}
