<?php

namespace App\Http\Controllers\API\V1\Messages;

use App\Http\Controllers\Controller;
use App\Http\Requests\API\UpdateMessageRequest;
use App\Http\Resources\MessageResource;
use App\Models\Message;

class UpdateController extends Controller
{
    public function __invoke(UpdateMessageRequest $request, Message $message)
    {
        $message->load(['chat.user', 'sender', 'replyTo']);

        $user = auth()->user();

        abort_unless(
            $message->sender->is($user) || $message->chat->user->is($user),
            403,
            'Unauthorized to update this message.'
        );

        $message->update([
            'is_pinned' => $request->boolean('is_pinned'),
        ]);

        return MessageResource::make($message);
    }
}
