<?php

namespace App\Http\Controllers\API\V1;

use Agence104\LiveKit\WebhookReceiver;
use App\Http\Controllers\Controller;
use Exception;
use Log;

class WebhookController extends Controller
{
    /**
     * @throws Exception
     */
    public function __invoke()
    {
        $webhookReceiver = (new WebhookReceiver(
            apiKey: config('livekit.API_KEY'),
            apiSecret: config('livekit.API_SECRET'),
        ));

        $authHeader = request()->header('Authorization');

        $body = file_get_contents("php://input");

        try {
            $event = $webhookReceiver->receive($body, $authHeader);

            Log::info('LiveKit Webhook: ' . print_r($event->getEvent() . ' Room:' . $event->getRoom()?->getName(), true));
        } catch (Exception $e) {
            Log::info('Error validating webhook event: ' . $e->getMessage());

            return response(505);
        }
    }
}
