<?php

namespace App\Http\Controllers;

use App\Actions\CreateChatRateAction;
use App\Actions\CreateMessageAction;
use App\Actions\UpdateMessageAction;
use App\Enums\MessageType;
use App\Enums\SupportCallStatus;
use App\Http\Requests\StoreChatRateRequest;
use App\Http\Requests\StoreMessageRequest;
use App\Http\Requests\UpdateMessageRequest;
use App\Http\Resources\ChatRateResource;
use App\Models\Admin;
use App\Models\Chat;
use App\Models\ChatRate;
use App\Models\Message;
use App\Models\SupportCall;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\Request;
use Inertia\Inertia;

class ChatRateController extends Controller
{
    public function show()
    {
        $rates = auth()->user()->ratetoable()->latest()
            ->with('ratefromable', 'ratetoable', 'chat')->get();
      //  return ChatRateResource::collection($rates)->jsonSerialize();
        return Inertia::render('ChatRates/Show', [
            'rates' => ChatRateResource::collection($rates)->jsonSerialize(),
        ]);
    }

    public function store(
        CreateChatRateAction $action,
        StoreChatRateRequest $request,
    )
    {
        $action->handle($request->validated());

        return back()->with('success', 'تم إرسال الرد بنجاح');
    }
}
