<?php

namespace App\Http\Controllers;

use App\Http\Requests\MessageReactionRequest;
use App\Models\Message;
use App\Models\MessageReaction;

class MessageReactionController extends Controller
{
    public function __invoke(Message $message, MessageReactionRequest $request)
    {
        $user = $request->user();
        $emoji = $request->input('emoji');

        $existing = MessageReaction::query()
            ->where('message_id', $message->id)
            ->where('actor_id', $user->id)
            ->where('actor_type', $user::class)
            ->where('chat_id', $message->chat_id)
            ->first();

        if ($existing && $existing->emoji === $emoji) {
            $existing->delete();

            return back();
        }

        if ($existing) {
            $existing->update([
                'emoji' => $emoji,
            ]);
        } else {
            MessageReaction::create([
                'emoji' => $emoji,
                'message_id' => $message->id,
                'actor_id' => $user->id,
                'actor_type' => $user::class,
                'chat_id' => $message->chat_id,
            ]);
        }

        return back();
    }
}
