<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;

class UserSearchController extends Controller
{
    public function __invoke(Request $request)
    {
        $q = trim((string)$request->get('q', ''));
        $limit = (int)$request->integer('limit', 10);
        $isSuperAdmin = auth()->user()->hasRole('super_admin');

        $users = User::query()
            ->when($q !== '', function ($query) use ($q) {
                $query->where(function ($qq) use ($q) {
                    $qq->where('name', 'like', "%{$q}%")
                        ->orWhere('phone', 'like', "%{$q}%");
                });
            })
            ->when(!$isSuperAdmin, function ($query) {
                $query->whereIn('branch_id', auth()->user()->branches()->pluck('id'));
            })
            ->orderBy('name')
            ->limit($limit)
            ->get(['id', 'name', 'phone', 'gender']);

        return response()->json($users);
    }
}
