<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreVisitRequest;
use App\Models\Visit;

class VisitController extends Controller
{
    public function store(
        StoreVisitRequest $request
    )
    {
        Visit::create([
            'date' => $request->date('date'),
            'note' => $request->string('note'),
            'user_id' => $request->integer('user_id'),
            'branch_id' => $request->integer('branch_id'),
        ]);

        return back()
            ->with('success', __('Visit created successfully.'));
    }
}
