<?php

namespace App\Http\Controllers\Webhook\LiveKit;

use Agence104\LiveKit\WebhookReceiver;
use App\Enums\StreamStatus;
use App\Enums\SupportCallStatus;
use App\Http\Controllers\Controller;
use App\Models\SupportCall;
use Exception;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Livekit\WebhookEvent;

class StoreController extends Controller
{
    public function __invoke(Request $request): JsonResponse
    {
        try {
            $event = (new WebhookReceiver(
                config('livekit.api_key'),
                config('livekit.api_secret')
            ))->receive(
                $request->getContent(),
                $request->header('Authorization')
            );

            $method = str_replace('.', '_', $event->getEvent());
            if (method_exists($this, $method)) {
                $this->$method($event);
            }

            return response()->json(['message' => 'Event processed']);
        } catch (Exception $e) {
            Log::error('LiveKit webhook error', ['error' => $e->getMessage()]);
            return response()->json(['error' => 'Webhook validation failed'], 401);
        }
    }

    protected function room_finished(WebhookEvent $event): void
    {
        if ($event->hasRoom()) {
            $roomName = $event->getRoom()->getName();

            SupportCall::where('room_name', $roomName)
                ->update([
                    'status' => SupportCallStatus::ENDED,
                    'ended_at' => now(),
                ]);
        }
    }
}
