<?php

namespace App\Http\Middleware;

use App\Models\Branch;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Inertia\Middleware;
use Tighten\Ziggy\Ziggy;

class HandleInertiaRequests extends Middleware
{
    /**
     * The root template that is loaded on the first page visit.
     *
     * @var string
     */
    protected $rootView = 'app';

    /**
     * Determine the current asset version.
     */
    public function version(Request $request): ?string
    {
        return parent::version($request);
    }

    /**
     * Define the props that are shared by default.
     *
     * @return array<string, mixed>
     */
    public function share(Request $request): array
    {
        $branches = auth('admin')?->user()?->hasPermissionTo('view_any_branch') ? Branch::get(['id', 'name']) : auth('admin')?->user()?->branches;

        return [
            ...parent::share($request),
            'flash' => function () {
                return [
                    'success' => Session::get('success'),
                    'error' => Session::get('error'),
                ];
            },
            'auth' => [
                'user' => $request->user(),
            ],
            'ziggy' => fn () => [
                ...(new Ziggy)->toArray(),
                'location' => $request->url(),
            ],
            'csrf_token' => csrf_token(),
            'branches' => $branches,
            'notificationCount' => function () {
                $user = Auth::user();

                if (!$user) return 0;
                return $user->getUnansweredMessagesCount();
            },
            'can' => function () {
                $user = Auth::user();
                return [
                    'view_chat' => $user?->hasPermissionTo('page_Chat'),
                    'view_calls_history' => $user?->hasPermissionTo('page_CallsHistory'),
                    'view_chat_rate' => $user?->hasPermissionTo('page_ChatRate'),
                ];
            },
            'is_super_admin' => function () {
                return Auth::user()?->hasRole('super_admin');
            }
        ];
    }
}
