<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class LocalizationMiddleware
{
    protected const ALLOWED_LOCALIZATIONS = ['en', 'ar'];

    public function handle(Request $request, Closure $next): Response
    {
        $localization = $request->header('Accept-Language');

        $localization = in_array($localization, self::ALLOWED_LOCALIZATIONS, true) ? $localization : 'en';

        app()->setLocale($localization);

        return $next($request);
    }
}
