<?php

namespace App\Http\Requests;

use App\Enums\SupportCallType;
use App\Models\Chat;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Illuminate\Validation\Validator;

class CreateSupportCallRequest extends FormRequest
{
    public function rules(): array
    {
        return [
            'type' => ['required', Rule::enum(SupportCallType::class)],
            'chat_id' => ['required', 'exists:chats,id'],
        ];
    }

    public function authorize(): bool
    {
        return true;
    }

    public function after(): array
    {
        return [
            function (Validator $validator) {
                if (auth('admin')->check()) return;

                $chat = Chat::find($this->chat_id);

                if ($chat->user_id != $this->user()->id) {
                    $validator->errors()->add(
                        'chat_id',
                        'Invalid chat_id.'
                    );
                }
            }
        ];
    }
}
