<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class MessageReactionRequest extends FormRequest
{
    public function rules(): array
    {
        return [
            'emoji' => [
                'required',
                'string',
                Rule::in('👍', '❤️', '😂', '😮', '😢', '🙏')
            ],
        ];
    }

    public function authorize(): bool
    {
        return true;
    }
}
