<?php

namespace App\Http\Requests;

use App\Enums\MessageType;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreChatRateRequest extends FormRequest
{
    public function rules(): array
    {
        return [
            'comment' => 'sometimes|string',
            'chat_id' => 'required|integer|exists:chats,id',
            'rate' => 'required|integer|min:1|max:5',
            'ratefromable_id' => 'sometimes|integer',
            "ratefromable_type" => 'sometimes|string|in:user,admin',
            'ratetoable_id' => 'required|integer',
            "ratetoable_type" => 'sometimes|string|in:user,admin',
        ];
    }

//    protected function prepareForValidation(): void
//    {
//        if ($this->request->has('type')) {
//            match ($this->enum('type', MessageType::class)) {
//                MessageType::TEXT => $this->merge([
//                    'attachments' => 'sometimes',
//                    'attachments.*' => 'sometimes',
//                ]),
//                MessageType::IMAGE, MessageType::AUDIO, MessageType::VIDEO, MessageType::FILE => $this->merge([
//                    'attachments' => [
//                        'required',
//                        'array',
//                    ],
//                    'attachments.*' => [
//                        'required',
//                        'file',
//                        'max:25000', // Max 25MB
//                        'mimes:jpg,jpeg,png,gif,webp,mp4,3gp,mkv,mov,avi,mp3,aac,ogg,wav,m4a,pdf,doc,docx,xls,xlsx,ppt,pptx,txt,csv,zip,rar,apk'
//                    ],
//                ]),
//            };
//        }
//    }

    public function authorize(): bool
    {
        return true;
    }
}
