<?php

namespace App\Http\Requests;

use App\Enums\MessageType;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreMessageRequest extends FormRequest
{
    public function rules(): array
    {
        return [
            'text' => [
                'required_if:type,' . MessageType::TEXT->value,
            ],
            'reply_to_id' => [
                'sometimes',
                'exists:messages,id'
            ],
            'chat_id' => [
                'required',
                Rule::exists('chats', 'id')->where(function ($query) {
                    if (!auth('admin')->check()) {
                        return $query->where('user_id', auth()->id());
                    }
                })
            ],
            'tmp_front_id' => [
                'sometimes',
                'string',
            ],
            'attachments' => [
                'sometimes',
            ],
            'attachments.*' => [
                'required',
                'file',
                'max:250000',
                'mimes:jpg,jpeg,png,gif,webm,webp,mp4,3gp,mkv,mov,avi,mp3,aac,ogg,wav,m4a,pdf,doc,docx,xls,xlsx,ppt,pptx,txt,csv,zip,rar,apk'
            ]
        ];
    }

//    protected function prepareForValidation(): void
//    {
//        if ($this->request->has('type')) {
//            match ($this->enum('type', MessageType::class)) {
//                MessageType::TEXT => $this->merge([
//                    'attachments' => 'sometimes',
//                    'attachments.*' => 'sometimes',
//                ]),
//                MessageType::IMAGE, MessageType::AUDIO, MessageType::VIDEO, MessageType::FILE => $this->merge([
//                    'attachments' => [
//                        'required',
//                        'array',
//                    ],
//                    'attachments.*' => [
//                        'required',
//                        'file',
//                        'max:25000', // Max 25MB
//                        'mimes:jpg,jpeg,png,gif,webp,mp4,3gp,mkv,mov,avi,mp3,aac,ogg,wav,m4a,pdf,doc,docx,xls,xlsx,ppt,pptx,txt,csv,zip,rar,apk'
//                    ],
//                ]),
//            };
//        }
//    }

    public function authorize(): bool
    {
        return true;
    }
}
