<?php

namespace App\Http\Requests;

use App\Enums\MessageType;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateMessageRequest extends FormRequest
{
    public function rules(): array
    {
        return [
            'type' => [
                'required',
                Rule::enum(MessageType::class),
            ],
            'text' => [
                'required_if:type,' . MessageType::TEXT->value,
            ],
            'attachment' => [
                'required_unless::type,' . MessageType::TEXT->value,
            ],
        ];
    }

    public function authorize(): bool
    {
        return true;
    }
}
