<?php

namespace App\Http\Resources;

use App\Models\Admin;
use App\Models\Chat;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use TiMacDonald\JsonApi\JsonApiResource;

/**
 * @property-read Chat $resource
 */
final class ChatRateResource extends JsonApiResource
{
//    protected array $relationships = [
//        'ratefromable', 'ratetoable', 'chat'
//    ];

    public function toAttributes(Request $request): array
    {
        // Safe defaults
        $ratefromable = $this->resource->ratefromable_type;
        $photo_from = null;

        $ratetoable = $this->resource->ratetoable_type;
        $photo_to = null;

        $is_repaid = false;

        // Handle ratefromable types
        if ($this->resource->ratefromable_type == User::class) {
            $ratefromable = 'user';
            $photo_from = $this->resource->ratefromable->getFirstMedia('photo');
        } elseif ($this->resource->ratefromable_type == Admin::class) {
            $ratefromable = 'admin';
            $photo_from = $this->resource->ratefromable->avatar_url
                ? Storage::url($this->resource->ratefromable->avatar_url)
                : null;
        }

        // Handle ratetoable types
        if ($this->resource->ratetoable_type == User::class) {
            $ratetoable = 'user';
            $photo_to = $this->resource->ratetoable->getFirstMedia('photo');
        } elseif ($this->resource->ratetoable_type == Admin::class) {
            $ratetoable = 'admin';
            $photo_to = $this->resource->ratetoable->avatar_url
                ? Storage::url($this->resource->ratetoable->avatar_url)
                : null;
        }

        // if chat has ratefromable and ratetoable return is repaid
        if ($this->resource->chat->rates()->count() >= 2) {
            $is_repaid = true;
        } else {
            $is_repaid = false;
        }


        return [
            'id' => $this->resource->id,
            'rate' => $this->resource->rate,
            'comment' => $this->resource->comment,
            'chat_id' => $this->resource->chat_id,
            "is_repaid" => $is_repaid,
            "rate_from" => [
                'id' => $this->resource->ratefromable_id,
                'type' => $ratefromable,
                'name' => $this->resource->ratefromable->name,
                'photo' => $photo_from  ?? asset('images/default-user.png'),
            ],

            "rate_to" => [
                'id' => $this->resource->ratetoable_id,
                'type' => $ratetoable,
                'name' => $this->resource->ratetoable->name,
                'photo' => $photo_to ?? asset('images/default-user.png'),
            ],

            'created_at' => new DateTimeResource($this->resource->created_at),
            'updated_at' => new DateTimeResource($this->resource->updated_at),
        ];
    }
}
