<?php

namespace App\Http\Resources;

use App\Models\Chat;
use Illuminate\Http\Request;
use TiMacDonald\JsonApi\JsonApiResource;

/**
 * @property-read Chat $resource
 */
final class ChatResource extends JsonApiResource
{
    protected array $relationships = [
        'messages',
    ];

    public function toAttributes(Request $request): array
    {
        return [
            'id' => $this->resource->id,
            'status' => $this->resource->status,
            "admin_id" => $this->resource->admin_id,
            "user_id" => $this->resource->user_id,
            'created_at' => new DateTimeResource(
                resource: $this->resource->created_at,
            ),
            'updated_at' => new DateTimeResource(
                resource: $this->resource->updated_at,
            ),
        ];
    }
}
