<?php

namespace App\Http\Resources;

use Carbon\CarbonInterface;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/**
 * @property-read CarbonInterface $resource
 */
final class DateTimeResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'human' => $this->resource?->diffForHumans(),
            'timestamp' => $this->resource?->timestamp,
            'string' => $this->resource?->toDateTimeString(),
        ];
    }
}
