<?php

namespace App\Http\Resources;

use App\Models\MessageReaction;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin MessageReaction */
class MessageReactionResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'emoji' => $this->emoji,
            'actor_name' => $this->actor?->name,
            'actor_photo_url' => $this->actor?->photo_url,
        ];
    }
}
