<?php

namespace App\Http\Resources;

use App\Models\Message;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use TiMacDonald\JsonApi\JsonApiResource;

/**
 * @property-read Message $resource
 */
final class MessageResource extends JsonApiResource
{
    public function toAttributes(Request $request): array
    {
        return [
            'id' => $this->resource->id,
            'text' => $this->resource->text,
            'type' => $this->resource->type,
            'read_at' => $this->resource->read_at,
            'is_pinned' => $this->resource->is_pinned,

            'chat_id' => $this->resource->chat_id,
            'sender_id' => $this->resource->sender_id,
            'sender_type' => Str::replace('App\\Models\\', '', $this->resource->sender_type),

            'sender' => $this->resource->sender->only(['id', 'name', 'photo_url']),
            'reply_to' => $this->resource->replyTo?->only(['id', 'text']),
            'reactions' => $this->whenLoaded('reactions', MessageReactionResource::collection($this->resource->reactions)),

            'media' => $this->resource->media->map(function ($media) {
                return [
                    'id' => $media->id,
                    'mime_type' => $media->mime_type,
                    'url' => $media->original_url,
                ];
            }),

            'created_at' => new DateTimeResource(
                resource: $this->resource->created_at,
            ),
            'updated_at' => new DateTimeResource(
                resource: $this->resource->updated_at,
            ),
        ];
    }
}
