<?php

namespace App\Http\Resources;

use App\Models\SupportCall;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin SupportCall */
class SupportCallResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        $this->loadMissing('user');

        return [
            'id' => $this->id,
            'status' => $this->status,
            'type' => $this->type,
            'room_name' => $this->room_name,
            'started_at' => $this->started_at,
            'answered_at' => $this->answered_at,
            'ended_at' => $this->ended_at,

            'user' => $this->user->only(['id', 'name', 'photo_url']),

            'created_at' => $this->created_at,
        ];
    }
}
