<?php

namespace App\Jobs;

use App\Enums\SupportCallStatus;
use App\Events\UpdateSupportCallEvent;
use App\Models\SupportCall;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class MarkCallAsMissedJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function __construct(
        private readonly SupportCall $call,
    )
    {
    }

    public function handle(): void
    {
        if ($this->call && $this->call->status === SupportCallStatus::PENDING) {
            $this->call->update([
                'status' => SupportCallStatus::MISSED,
            ]);

            event(new UpdateSupportCallEvent($this->call));
        }
    }
}
