<?php

namespace App\Listeners;

use App\Events\MessageCreatedEvent;
use App\Services\LiveKitService;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Contracts\Queue\ShouldQueueAfterCommit;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

final class MessageCreatedListener implements ShouldQueue, ShouldQueueAfterCommit
{
    use InteractsWithQueue;

    public function __construct(
        private LiveKitService $service,
    )
    { }

    public function handle(MessageCreatedEvent $event): void
    {
        $message = $event->message;
        $chat = $event->chat;

        $this->service->sendMessage(
            $chat->livekit_room_name,
            $message->text,
        );
    }
}
