<?php

namespace App\Listeners;

use App\Events\NewChatMessage;
use App\Notifications\FcmPushNotification;

class SendNewChatMessageNotification
{
    public function handle(NewChatMessage $event)
    {
        $chat = $event->chat;
        $message = $event->message;

        $user = $chat->user;

        $title = 'DreamFitness';
        $body = $message->text;

        $data = [
            'linkable_type' => 'chat',
            'linkable_id' => $chat->id,
            'chat_id' => $chat->id,
            'message_id' => $message->id,
        ];

        if ($user) {
            $user->notify(new FcmPushNotification($title, $body, null, $data));
        }
    }
}
