<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;

class Branch extends Model
{
    public function users(): HasMany
    {
        return $this->hasMany(User::class);
    }

    public function groupChat(): HasOne
    {
        return $this->hasOne(Chat::class)->where('type', 'group');
    }

    public function groupChats(): HasMany
    {
        return $this->hasMany(Chat::class)->where('type', 'group');
    }
}
