<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphTo;
class ChatRate extends Model
{
    protected $fillable = [
        'ratefromable_id',
        'ratefromable_type',
        'ratetoable_id',
        'ratetoable_type',
        'chat_id',
        'rate',
        'comment',
    ];

    public function ratefromable(): MorphTo
    {
        return $this->morphTo();
    }

    public function ratetoable(): MorphTo
    {
        return $this->morphTo();
    }

    public function chat()
    {
        return $this->belongsTo(Chat::class);
    }
}
