<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class DietPlan extends Model
{
    protected $fillable = [
        'name',
        'diet_plan_category_id',
    ];
    public function category(): BelongsTo
    {
        return $this->belongsTo(DietPlanCategory::class, 'diet_plan_category_id');
    }
}
