<?php

namespace App\Models;

use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Database\Eloquent\BroadcastsEvents;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphTo;

class MessageReaction extends Model
{
    use BroadcastsEvents;

    public function message(): BelongsTo
    {
        return $this->belongsTo(Message::class);
    }

    public function actor(): MorphTo
    {
        return $this->morphTo();
    }

    public function chat(): BelongsTo
    {
        return $this->belongsTo(Chat::class);
    }

    public function broadcastOn(string $event): array
    {

        return [
            new PrivateChannel('Support.Chat.' . $this->chat_id),
            new PrivateChannel('Support.Chats'),
        ];
    }

    public function broadcastAs(string $event): string
    {
        return match ($event) {
            'created' => 'MessageReactionCreated',
            'updated' => 'MessageReactionUpdated',
            'deleted' => 'MessageReactionDeleted',
            default   => 'MessageReaction' . ucfirst($event),
        };
    }

    public function broadcastWith(string $event): array
    {
        return [
            'reaction' => [
                'id' => $this->id,
                'emoji' => $this->emoji,
                'message_id' => $this->message_id,
                'chat_id' => $this->chat_id,
                'actor' => [
                    'id' => $this->actor_id,
                    'type' => $this->actor_type,
                    'name' => $this->actor?->name,
                ],
                'created_at' => optional($this->created_at)?->toISOString(),
                'updated_at' => optional($this->updated_at)?->toISOString(),
            ],
        ];
    }
}
