<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Model;

class Subscription extends Model
{
    protected $appends = [
        'plan_name'
    ];

    public function plan()
    {
        return $this->belongsTo(Plan::class);
    }

    public function planName(): Attribute
    {
        if (!$this->relationLoaded('plan')) {
            $this->load('plan');
        }

        return Attribute::make(
            get: fn () => $this->plan?->name ?? ''
        );
    }
}
