<?php

namespace App\Models;

use App\Enums\SupportCallStatus;
use App\Enums\SupportCallType;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class SupportCall extends Model
{
    use HasFactory;

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function admin(): BelongsTo
    {
        return $this->belongsTo(Admin::class);
    }

    public function chat(): BelongsTo
    {
        return $this->belongsTo(Chat::class);
    }

    protected function casts(): array
    {
        return [
            'type' => SupportCallType::class,
            'status' => SupportCallStatus::class,
            'answered_at' => 'timestamp',
            'started_at' => 'timestamp',
            'ended_at' => 'timestamp',
        ];
    }
}
