<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use NotificationChannels\Fcm\FcmChannel;
use NotificationChannels\Fcm\FcmMessage;
use NotificationChannels\Fcm\Resources\Notification as FcmNotification;

class FcmPushNotification extends Notification
{
    use Queueable;

    protected string $title;

    protected string $body;

    protected ?string $image;

    protected array $data;

    public function __construct(string $title, string $body, ?string $image = null, array $data = [])
    {
        $this->title = $title;
        $this->body = $body;
        $this->image = $image;
        $this->data = $data;
    }

    public function via($notifiable): array
    {
        return [FcmChannel::class];
    }

    public function toFcm($notifiable): FcmMessage
    {
        $notification = FcmNotification::create()
            ->title($this->title)
            ->body($this->body);

        if ($this->image) {
            $notification->image($this->image);
        }

        return FcmMessage::create()
            ->notification($notification)
            ->data(array_map('strval', $this->data));
    }
}
