<?php

namespace App\Policies;

use App\Models\Chat;
use App\Models\Admin;
use Illuminate\Auth\Access\HandlesAuthorization;

class ChatPolicy
{
    use HandlesAuthorization;

    public function viewAny(Admin $admin): bool
    {
        return $admin->hasPermissionTo('page_Chat');
    }

    public function view(Admin $admin, Chat $chat): bool
    {
        return $admin->hasPermissionTo('page_Chat');
    }

    public function create(Admin $admin): bool
    {
        return $admin->hasPermissionTo('page_Chat');
    }

    public function update(Admin $admin, Chat $chat): bool
    {
        return $admin->hasPermissionTo('page_Chat');
    }

    public function delete(Admin $admin, Chat $chat): bool
    {
        return $admin->hasPermissionTo('page_Chat');
    }

    public function restore(Admin $admin, Chat $chat): bool
    {
        return $admin->hasPermissionTo('page_Chat');
    }

    public function forceDelete(Admin $admin, Chat $chat): bool
    {
        return $admin->hasPermissionTo('page_Chat');
    }
}
